# rancher部署手动转化步骤 #

* 1. [官网最新版下载地址](https://github.com/goharbor/harbor/releases)，下载版本后解压。使用Online版即可。

```
tar xvf harbor-online-installer-<version>.tgz
```
* 2. 进入解压的目录harbor，编辑配置文件harbor.cfg，只需要修改harbor的配置hostname为访问域名和访问协议为http即可，其他保留默认。

```
#The IP address or hostname to access admin UI and registry service.
#DO NOT use localhost or 127.0.0.1, because Harbor needs to be accessed by external clients.
#DO NOT comment out this line, modify the value of "hostname" directly, or the installation will fail.
hostname = harbor.example.com

#The protocol for accessing the UI and token/notification service, by default it is http.
#It can be set to https if ssl is enabled on nginx.
ui_url_protocol = http
```
* 3. 使用python运行harbor目录中的配置文件生成脚本prepare

```
python prepare
```
* 4. 配置文件生成完毕后，查看harbor目录的docker-compose.yml文件，去除log服务、proxy服务，然后把配置文件中各服务的镜像、环境变量、存储对应填入rancher中启动即可。
* 5. 相关存储对应rancher关系参考：

> rancher存储挂载：

```
  registry:
    volumes:
    - data-registry:/storage
    - etc-registry:/etc/registry

  core:
    volumes:
    - etc-core:/etc/core
    - data-core:/data

  jobservice:
    volumes:
    - data-joblogs:/var/log/jobs
    - etc-jobservice:/etc/jobservice

  postgresql:
    volumes:
    - data-progresql:/var/lib/postgresql/data

  adminserver:
    volumes:
    - etc-core:/etc/adminserver
    - data-core:/data

  registryctl:
    volumes:
    - data-registry:/storage
    - etc-registry:/etc/registry
    - etc-registryctl:/etc/registryctl
	
  redis:
    volumes:
    - data-redis:/var/lib/redis
```
> 原存储挂载：

```
  registry:
    volumes:
      - /data/registry:/storage:z
      - ./common/config/registry/:/etc/registry/:z
      - ./common/config/custom-ca-bundle.crt:/harbor_cust_cert/custom-ca-bundle.crt:z

  registryctl:
    volumes:
      - /data/registry:/storage:z
      - ./common/config/registry/:/etc/registry/:z
      - ./common/config/registryctl/config.yml:/etc/registryctl/config.yml:z

  postgresql:
    volumes:
      - /data/database:/var/lib/postgresql/data:z

  adminserver:
    volumes:
      - /data/config/:/etc/adminserver/config/:z
      - /data/secretkey:/etc/adminserver/key:z
      - /data/:/data/:z

  core:
    volumes:
      - ./common/config/core/app.conf:/etc/core/app.conf:z
      - ./common/config/core/private_key.pem:/etc/core/private_key.pem:z
      - ./common/config/core/certificates/:/etc/core/certificates/:z
      - /data/secretkey:/etc/core/key:z
      - /data/ca_download/:/etc/core/ca/:z
      - /data/psc/:/etc/core/token/:z
      - /data/:/data/:z

  jobservice:
    volumes:
      - /data/job_logs:/var/log/jobs:z
      - ./common/config/jobservice/config.yml:/etc/jobservice/config.yml:z

  redis:
    volumes:
      - /data/redis:/var/lib/redis
```
* 6. 由于rancher存储挂载后，应该在配置目录下有默认生成的配置文件，需要手动写入到对应配置目录中，否则容器启动异常。
